package easik.ui.menu;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;
import easik.states.AddSumConstraintState;


/**
 * The menu action which creates simple sum constraints.
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-05-23 Kevin Green
 */
public class AddSumConstraintAction extends AbstractAction {

	/**
	 * Creates and initializes the menu option.
	 *
	 */
	public AddSumConstraintAction() {
		super();
		putValue(AbstractAction.NAME, "Add a Sum Constraint");
		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Assign a sum constraint to a set of injective paths");
	}

	/**
	 * Creates a sum constraint if the selection allows that.
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e) {
		if(!Easik.getInstance().getFrame().getSketch().getEntities().isEmpty()){
			Easik.getInstance().getStateManager().pushState(
				new AddSumConstraintState(Easik.getInstance().getFrame().getSketch()));
		}
		else{
			JOptionPane.showMessageDialog(null, "Sketch cannot be empty.", "Error", JOptionPane.ERROR_MESSAGE);
		}
	}

}
